#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_WorkloadCodes : BaseTest 
	{

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void GetWorkloadCodesData_Pass()
		{
			DataSet dsTest = DAL.VAL.WorkloadCodes.GetWorkloadCodeData();

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(true, dsTest.Tables[0].Rows.Count > 0, "[0].Rows.Count");
			Assert.AreEqual(true, dsTest.Tables[1].Rows.Count > 0, "[1].Rows.Count");
			Assert.AreEqual(6, dsTest.Tables[0].Columns.Count, "[0]Columns.Count");

			DataTable dtTest = dsTest.Tables[0];
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.Lmip), Common.VbecsTables.WorkloadCache.Lmip);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.WeightMultiplier), Common.VbecsTables.WorkloadCache.WeightMultiplier);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.Code_Id), Common.VbecsTables.WorkloadCache.Code_Id);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.Cost), Common.VbecsTables.WorkloadCache.Cost);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.Procedure), Common.VbecsTables.WorkloadCache.Procedure);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.WorkloadCache.LastUpdateDate), Common.VbecsTables.WorkloadCache.LastUpdateDate);

			Assert.AreEqual(3, dsTest.Tables[1].Columns.Count, "[1]Columns.Count");

			dtTest = dsTest.Tables[1];
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.CptCache.Code_Id), Common.VbecsTables.CptCache.Code_Id);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.CptCache.CPTCode_Text), Common.VbecsTables.CptCache.CPTCode_Text);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.VbecsTables.CptCache.LastUpdateDate), Common.VbecsTables.CptCache.LastUpdateDate);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetWorkloadCodesData_Fail()
		{
			//New cache implementation prevents this from failing
		}
	}
}
#endif
